---------------------------------------------------------------------------
- Source Lines of Code Counter (SLOCC)
- Language Profile:
-
- Possible counting types for detection in a language are:
-   view = range
-        - Restrict range of examination. Usually used to skip over
-          line numbers.
-   comments = set_of_ranges
-        - Comments are NOT counted as source code. Every physical line
-          within a comment is counted as a comment line. Once a comment
-          starts, only the matching end of range will terminate it.
-   ignore = set_of_ranges
-        - No source code counting takes place with these regions. The region
-          is considered to be source code. Comments regions can be found
-          within ignore regions.
-   escape = set_of_ranges
-        - Characters within the region cannot be considered by SLOCC as
-          region marker. The region is considered to be source code.
-   continue_on_next = indicator
-        - The next line is a continuation of the current line.
-   continue_from_last = indicator
-        - The current line is a continuation of the previous line.
-   line = set_of_ranges
-        - Source code within this region is counted as a line of code.
-          Regions that do not contain any source code are not counted.
-          This means that characters outside the view and comments
-          (including the start and end comment indicators) do not count
-          as source code.
-   field_separator = indicator
-        - Characters that separate fields in this language. The default
-          is whitespace (blanks and tabs).
-   alternate = set_of_ranges
-        - Change how counting is done within this region. Alternates must
-          be the last types in a language profile.
-
- indicator:
-   A set of characters that serves as a indication of one the above types.
-   A basic indicator is a regular expression enclosed in <>.
-   If no expression is given, then any non-blank character will match.
-   You can specify where an indicator must be found by prefixing it
-   with one of the following:
-   S  - Must start at the beginning of a physical line.
-   L  - Must start at the beginning of a source line.
-   Cx - Must start at column x in a line. (where x is 1 to 256)
-   Fx - Must start in field x in a line. A field is a series of
-        non-separators. F1 is from the beginning of a line. If the first
-        character is a field separator, then we begin F2 at the next
-        non-separator character.
-
- regular expression:
-   A pattern bracketed by < and >. The pattern consists of:
-   a character    - must match exactly
-                    a matches only a
-   -              - a range from preceding character to following character
-                    a-d is shorthand for abcd.
-   |              - either match the preceding or the following
-                    a|b matches either a or b
-   []             - match one of the characters within the braces
-                    [ad-f] matches either a, d, e, or f
-   [^]            - match anything but the characters in the braces
-                    [^abc] matches anything otherthan a, b, or c
-   ()             - grouping of patterns. This is nestable.
-                    As each group is matched, it is placed in a register.
-                    (a|b|c)d matches ad, bd, or cd
-   *              - preceding matches 0 or more times
-                    a* matches nothing, a, aa, aaa, ...
-   +              - preceding matches 1 or more times
-                    a+ matches a, aa, aaa, ...
-   ?              - precediing matches 0 or 1 times
-                    a? matches nothing or a
-   {x,y}          - preceding matches x to y times
-                    a{2,3} matches aa or aaa
-   $              - matches the end of the current line.
-   .              - match any single character.
-   \              - escapes the next character
-                    \( matches (
-   \t             - matches tab character
-   \1 to \9       - Retreives the contents of register n.
-                    Each register is a previous group matching.
-                    (a*)b(c+)\1d\2 will match aaabccccaaadcccc
-                    In this case \1 becomes aaa and \2 becomes cccc
-   PLEASE NOTE: as currently implemented you cannot use > inside an
-   indicator expression.
-
- range:
-   indicator1 ... indicator2
-       a region starts with indicator 1 and ends with the first encounter
-       of indicator 2.
-   indicator1 .n. indicator2
-       a region starts with indicator 1 and ends with a matching indicator 2.
-       The same region may appear multiple times within a region (i.e. the
-       regions are nestable).
-
- set_of_ranges:
-   one or more ranges separated by whitespace.
-
- NOTE: language definitions MUST be separated by at least one blank line.
---------------------------------------------------------------------------
---------------------------------------------------------------------------
- COBOL
---------------------------------------------------------------------------
cbl: comments = <\*> ... <$>
     ignore   = <'> ... <'>
     line     = <[^ \t\n]> ... <(\.$|\. )>

---------------------------------------------------------------------------
- C
-
- The left { is used because SLOCC doesn't count empty statements and C
- programs tend to have a series of } with no intervening code. The override
- for 'for' statements is to allow counting the parts of a 'for' that is in
- the parentheses. The ignoring of = { ... } is to prevent counting the
- array and structure initialization code. The third alternative prevents
- counting parameters in function calls and function definitions.
-
- The definition here follows ANSI C. Specifically, it does not allow
- the Microsoft extension of using // for line comments.
---------------------------------------------------------------------------
c:   comments = </\*> ... <\*/>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n#]> ... <[;,{]> S<[ \t]*#> ... <\n>
     escape   = <\\> ... <(.|\n)>
     continue_on_next = <\\\n>
     alternate = L<[ \t]*for[ \t]*\(> ... <;>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'>
        line     = <[^ \t\n]> ... <[;,]>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>
     alternate = <=[ \t]*\{> ... <\}>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'> <\{> .n. <\}>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>
     alternate = <\(> .n. <\)>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>

h:   comments = </\*> ... <\*/>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n#]> ... <[;,{]> S<[ \t]*#> ... <\n>
     escape   = <\\> ... <.>
     continue_on_next = <\\\n>
     alternate = <= *\{> ... <\}>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'> <\{> .n. <\}>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>
     alternate = <\(> .n. <\)>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>

---------------------------------------------------------------------------
- C++
-
- The only difference between C and C++ is that // ... \n is added for
- line comments. Unfortunately, C and C++ use .h as the header file
- extension, so I can't distinguish commenting conventions.
---------------------------------------------------------------------------
cpp: comments = </\*> ... <\*/> <//> ... <\n>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n]> ... <[;,{]> S< *#> ... <\n>
     escape   = <\\> ... <.>
     continue_on_next = <\\\n>
     alternate = L< *for *\(> ... <;>
        comments = </\*> ... <\*/> <//> ... <\n>
        ignore   = <"> ... <"> <'> ... <'>
        line     = <[^ \t\n]> ... <[;,]>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>
     alternate = <= *\{> ... <\}>
        comments = </\*> ... <\*/> <//> ... <\n>
        ignore   = <"> ... <"> <'> ... <'> <\{> .n. <\}>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>
     alternate = <\(> .n. <\)>
        comments = </\*> ... <\*/> <//> ... <\n>
        ignore   = <"> ... <"> <'> ... <'>
        escape   = <\\> ... <.>
        continue_on_next = <\\\n>

---------------------------------------------------------------------------
- Pascal
-
- We have to ignore characters within parenthesis because semicolons are
- used to separate parameters.
---------------------------------------------------------------------------
pas: comments = <\{> ... <\}> <\(\*> ... <\*\)> <!> ... <\n>
     ignore   = <'> ... <'> <\(> .n. <\)>
     line     = <[^ \t\n]> ... <[;,]>

---------------------------------------------------------------------------
- Modula-2
-
- We have to ignore characters within parenthesis because semicolons are
- used to separate parameters.
---------------------------------------------------------------------------
mod: comments = <\(\*> ... <\*\)>
     ignore   = <'> ... <'> <\(> .n. <\)>
     line     = <[^ \t\n]> ... <[;,]>

---------------------------------------------------------------------------
- Microsoft Assembler
---------------------------------------------------------------------------
asm: comments = <;> ... <\n>
     ignore   = <'> ... <'>
     line     = <[^ \t\n]> ... <\n>

---------------------------------------------------------------------------
- Ada
-
- We have to ignore characters within parenthesis because semicolons are
- used to separate parameters. However, to allow counting comments about
- we use an alternative definition.
---------------------------------------------------------------------------
ada: comments = <--> ... <\n>
     ignore   = <"> ... <">
     line     = <[^ \t\n]> ... <[;,]>
     alternate = <\(> .n. <\)>
        comments = <--> ... <\n>
        ignore   = <"> ... <">

---------------------------------------------------------------------------
- BASIC
-
- BASIC stores ASCII versions of the program in files with a .ASC extension.
---------------------------------------------------------------------------
asc: comments = L< *('|REM |rem |Rem )> ... <\n>
     ignore   = <"> ... <">
     view     = F2<> ... <\n>
     line     = <[^ \t\n]> ... <(\n|:)>

---------------------------------------------------------------------------
- PL/I
-
- Unlike C or Pascal, PL/I programmers tend to use one declare statement
- to cover all variables. The alternative mode defines the shift from
- semicolon separators to comma separators.
---------------------------------------------------------------------------
pli: comments = </\*> ... <\*/>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n]> ... <;>
     view     = C1<> ... C72<>
     alternate = L< *(DCL[ \t\n]|DECLARE[ \t\n])> ... <;>
        comments = </\*> ... <\*/>
        ignore   = <"> ... <"> <'> ... <'> <\(> ... <\)>
        line     = <[^ \t\n]> ... <(,|;)>
        view     = C1<> ... C72<>

---------------------------------------------------------------------------
- DOS Batch Files
---------------------------------------------------------------------------
bat: comments = S< *(REM|rem|Rem)> ... <\n>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n]> ... <\n>

---------------------------------------------------------------------------
- OS/2 Batch Files
---------------------------------------------------------------------------
cmd: comments = S< *(REM|rem|Rem)> ... <\n>
     ignore   = <"> ... <"> <'> ... <'>
     line     = <[^ \t\n]> ... <\n>

---------------------------------------------------------------------------
- Fortran
---------------------------------------------------------------------------
f:   comments = S<[cC]> ... <\n>
     ignore   = <"> ... <"> <'> ... <'>
     continue_from_last = C1<[^cC]....[^ \t\n]>
     view     = C1<> ... C72<>
     line     = S<......[^ \t\n]*> ... <\n>

---------------------------------------------------------------------------
- Jovial (A U.S. Air Force Language)
---------------------------------------------------------------------------
jov:  comments = <"> ... <"> <%> ... <%>
      view     = C1<> ... C72<>
      line     = <[^ \t\n]> ... <;>
      alternate = L< *(DEFINE|define|Define) *"> ... <" *;>
         comments = <%> ... <%>
         view     = C1<> ... C72<>
         line     = <[^ \t\n]> ... <;>

---------------------------------------------------------------------------
- CMS2   (A U.S. Navy Language)
---------------------------------------------------------------------------
cms:   comments = <''> ... <''> C10<(COMMENT|comment|Comment)> ... <\n>
       view     = C10<> ... C80<>
       line     = <[^ \t\n]> ... <\$>

mac:  comments = <.> ... <\n>
      ignore   = <'> ... <'>
      continue_on_next = <;>
      view     = C1<> ... C72<>
      line     = <[^ \t\n]> ... <\n>
